/* ***************************************************************** 
    MESQUITE -- The Mesh Quality Improvement Toolkit

    Copyright 2004 Sandia Corporation and Argonne National
    Laboratory.  Under the terms of Contract DE-AC04-94AL85000 
    with Sandia Corporation, the U.S. Government retains certain 
    rights in this software.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License 
    (lgpl.txt) along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 
    diachin2@llnl.gov, djmelan@sandia.gov, mbrewer@sandia.gov, 
    pknupp@sandia.gov, tleurent@mcs.anl.gov, tmunson@mcs.anl.gov      
   
  ***************************************************************** */
  
#include "Mesquite_all_headers.hpp"
#include "PS.hpp"
#include <ostream>
using namespace Mesquite;
int main(int argc, char* argv[])
{
  MsqError err;
  
  if (argc != 2) {
    std::cerr << "Expected mesh file names as single argument." << std::endl;
    exit (EXIT_FAILURE);
  }

  Mesquite::MeshImpl my_mesh;
  my_mesh.read_vtk(argv[1], err); 
  if (err) 
  {
    std::cout << err << std::endl;
    return 1;
  }

      // creates a mean ratio quality metric ...
  AspectRatioGammaQualityMetric *qual_met = new AspectRatioGammaQualityMetric();

    // sets the objective function template
  //LPtoPTemplate obj_func(qual_met, 2, err);
  LInfTemplate obj_func(qual_met);
  
    // creates the optimization procedures
  //SteepestDescent solver(&obj_func);
  PS solver(&obj_func);
    //performs optimization globally
  //solver.use_global_patch(); 
  solver.use_element_on_vertex_patch(); 

    // creates a termination criterion and 
    // add it to the optimization procedure
    // outer loop: default behavior: 1 iteration
    // inner loop: stop if gradient norm < eps
  
  TerminationCriterion tc_inner, tc_outer;
  tc_inner.add_iteration_limit(2);
  solver.set_inner_termination_criterion(&tc_inner);
  tc_outer.add_cpu_time(3600); 
  tc_outer.add_iteration_limit(50);
  tc_outer.add_absolute_quality_improvement( -1 ); 
  solver.set_outer_termination_criterion(&tc_outer);
    // creates a quality assessor
  QualityAssessor qual_assess(qual_met,err);
    // creates an instruction queue
  InstructionQueue queue;
  queue.add_quality_assessor(&qual_assess, err); 
  queue.set_master_quality_improver(&solver, err); 
  queue.add_quality_assessor(&qual_assess, err); 

    // do optimization of the mesh_set
  queue.run_instructions(&my_mesh, err); 
  my_mesh.write_vtk("ps_smoothed.vtk", err); 
  if (err) {
    std::cout << err << std::endl;
    return 2;
  }
}

